/*------------------------------------------------------------------------
  **** BEGIN LICENSE BLOCK ****
  Version: MPL 1.1/GPL 2.0/LGPL 2.1
  Copyright(c) 2004-2010 Created by Eric Fredericksen (www.pttpsystems.com)
  All Rights Reserved.

  This program are subject to the Mozilla Public License Version
  1.1 (the "License"); you may not use this file except in compliance with
  the License. You may obtain a copy of the License at
  http://www.mozilla.org/MPL/

  This program is free software. Software distributed under the License
  is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
  either express or implied. See the License for the specific language
  governing rights and limitations under the License.

  Alternatively, the contents of this file may be used under the terms of
  either the GNU General Public License Version 2 or later (the "GPL"), or
  the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
  in which case the provisions of the GPL or the LGPL are applicable instead
  of those above. If you wish to allow use of your version of this file only
  under the terms of either the GPL or the LGPL, and not to allow others to
  use your version of this file under the terms of the MPL, indicate your
  decision by deleting the provisions above and replace them with the notice
  and other provisions required by the GPL or the LGPL. If you do not delete
  the provisions above, a recipient may use your version of this file under
  the terms of any one of the MPL, the GPL or the LGPL.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
  **** END LICENSE BLOCK ****
------------------------------------------------------------------------*/

#include "stdafx.h"
#include "ServerTools.h"
#include "ClientServer.h"
#include "AnagramServer.h"

//===================================================================
// Define my request thread by deriving from the generic task thread
//===================================================================
class CRequestThread : public CTaskThread
{
public:

protected:
	// use this to read and write
	SOCKET m_oRequestSocket;

	static CWordList * m_poWordList;

	sockaddr_in m_oTargetAddress;

	DWORD m_dwIndex;

public:
	void SetTargetAddress(DWORD _dwHBO_IP, USHORT _HBO_Port)
	{
		m_oTargetAddress.sin_family			= AF_INET;
		m_oTargetAddress.sin_addr.s_addr	= htonl(_dwHBO_IP);
		m_oTargetAddress.sin_port			= htons(_HBO_Port);
	}

	CRequestThread(void)
	{
		static bool bSRanded = false;
		if( !bSRanded )
		{
			srand( (unsigned int) time(NULL) );
			bSRanded = true;
		}

		m_dwIndex = rand();
		Sleep(100); // to make these different
		m_dwIndex = m_dwIndex*2 +1;
	}

	void Initialize(void)
	{
		m_oRequestSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
		if( INVALID_SOCKET  == m_oRequestSocket )
		{
			// record the error here for later inspection
			fprintf(stderr, _T("!!CRequestThread[%u] Could not create socket\n"), m_dwThreadID  );
			return;
		}
		DWORD dwTimeout_ms = 30000;
		setsockopt(m_oRequestSocket, SOL_SOCKET, SO_RCVTIMEO, (const char*)&dwTimeout_ms, sizeof(dwTimeout_ms) );
		setsockopt(m_oRequestSocket, SOL_SOCKET, SO_SNDTIMEO, (const char*)&dwTimeout_ms, sizeof(dwTimeout_ms) );
	}

	virtual DWORD VirtualCallbackFunction(void)
	{
		if( !m_poWordList ) return(FALSE);

		Initialize();

		string szWord = m_poWordList->ThreadSafeLookup(m_dwIndex++);
		int iResult =
			connect(m_oRequestSocket, (sockaddr*)&m_oTargetAddress, sizeof(m_oTargetAddress) );
		if( SOCKET_ERROR == iResult ) 
		{
			fprintf(stderr, _T("!!CRequestThread[%u] Could not connect socket\n"), m_dwThreadID  );
			return(FALSE);
		}
		iResult = send(m_oRequestSocket, szWord.c_str(), (int)szWord.size(), 0 );
		if( iResult == szWord.size() )
		{
			// read
			enum { MAX_BUF=2048 };
			char fatcBuf[MAX_BUF];
			iResult = recv(m_oRequestSocket, &fatcBuf[0], MAX_BUF-1, 0);
			if( iResult > 0 )
			{
				// ensure null termination
				fatcBuf[iResult]=0;

				fprintf(stderr,_T("[%u]Requested[%s]\tReceived<%s>\n"), m_dwThreadID, szWord.c_str(), fatcBuf );
			}
		}
		else
		{
			fprintf(stderr, _T("!!CRequestThread[%u] send didn't push all bytes or failed\n"), m_dwThreadID  );
		}

		shutdown(m_oRequestSocket, SD_BOTH);
		Sleep(20);
		closesocket(m_oRequestSocket);

		return(TRUE);
	}

};

// keep one for use
CWordList g_oWordList(  _T("wordlist.txt") );
// point our test class at it
CWordList * CRequestThread::m_poWordList = &g_oWordList;


using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	if( !g_oWordList.m_bWordListLoaded )
	{
		fprintf(stderr, _T("Failed to load the word list. Exiting....\n"));
		nRetCode = 1;
		return nRetCode;
	}

	CString szCommandLine = ::GetCommandLine();

	CAnagramServer oAnagramServer;

	enum { NOT_FOUND = -1 };
	// test the real thing using a browser to make requests
	if( NOT_FOUND != szCommandLine.Find(_T("-server")) )
	{
		oAnagramServer.BindTo( oAnagramServer.DefaultIP(), 10000 );
		oAnagramServer.StartListening();
		fprintf(stderr, _T("Exiting SERVER\n"));
		return(0);
	}

	if(NOT_FOUND != szCommandLine.Find(_T("-tester")) )
	{
		enum {MAX_TEST_THREADS = 10 };
		CRequestThread fatcTestThreads[MAX_TEST_THREADS];
		for(long K=0; K<MAX_TEST_THREADS; K++)
		{
			fatcTestThreads[K].SetTargetAddress( oAnagramServer.DefaultIP(), 10000);
		}

		long lCount = 100;
		while(0 < lCount-- )
		{
			// find a ready thread
			for(long K=0; K<MAX_TEST_THREADS; K++)
			{
				if(CRequestThread::WAITING == fatcTestThreads[K].GetThreadState() )
					fatcTestThreads[K].ReleaseThread();
			}
			Sleep(100);
		}
		Sleep(10000);
		fprintf(stderr,_T("exiting TESTER\n"));
		return(0);
	}


#ifdef _DEBUG
	//local test of wordlist lookup for multithreaded test harness
	if( 0 )
	{

		// rand is only 0-0x7fff -- not all words are tested...
		srand( (unsigned int) time(NULL) );
		DWORD dwIndex;

		for( long K=0; K<20; K++ )
		{
			string sz1 = g_oWordList.ThreadSafeLookup( dwIndex = rand() );
			fprintf(stderr,_T("WordList %d %s\n"), dwIndex, sz1.c_str() );
		}
	}

	//local test of dictionary lookup
	if( 0 )
	{
		// rand is only 0-0x7fff -- not all words are tested...
		srand(  (unsigned int) time(NULL) );
		DWORD dwIndex;

		CAnagramDictionary oDictionary;
		oDictionary.LoadWordList(_T("wordlist.txt"));

		for( long K=0; K<10; K++ )
		{
			string szWord = g_oWordList.ThreadSafeLookup( dwIndex = rand() );
			string szList = oDictionary.ThreadSafeLookup( szWord.c_str() );
			fprintf(stderr,_T("Word %s list %s\n"), szWord.c_str(), szList.c_str() );
		}
	}

	// local test of server base class
	if( 0 )
	{
		CServer oServer;
		oServer.BindTo( oServer.DefaultIP(), 10000 );
		oServer.StartListening();
	}

	// local test of thread base class
	if( 0 )
	{
		CTaskThread oTaskThread;
		Sleep(1000);
		// let the thread go to do no work but be exercised
		oTaskThread.ReleaseThread();
		// sleep to step through code without exiting and deleting the object ;)
		Sleep(100000);
	}
#endif // _DEBUG

	return nRetCode;
}
